<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
if ((function_exists('session_status') && session_status() !== PHP_SESSION_ACTIVE) || !session_id()) {
  session_start();
}
/****************************************************
*
* @File:      contact.php
* @Package:   GetSimple
* @Action:    GS Evolve for GetSimple CMS
*
*****************************************************/

include('header.inc.php');

$is_mail_meta = strpos(get_page_meta_desc(false), "@");
$is_meta_empty = get_page_meta_desc(false);
if(!empty($is_meta_empty) && $is_mail_meta !== false) {
	$e_mail = get_page_meta_desc(false);
} else {
	$e_mail = simple_c_default_email();
}
// Remove all illegal characters from email
$e_mail = filter_var($e_mail, FILTER_SANITIZE_EMAIL);

$Name = '';
$Email = '';
$Body = '';
$Subject = get_site_name(false);

$HasErrorName = '';
$HasErrorEmail = '';
$HasErrorSubject = '';
$HasErrorBody = '';
$HasErrorCaptcha = '';

$FormError = '';
$MailError = false;
$Success = false;

if (isset($_POST['cmdSendMessage'])) {
  $Name = $_POST['txtName'];
  $Email = $_POST['txtEmail'];
  $Body = $_POST['txtBody'];
  $Captcha = $_POST['captcha'];
		
  if (empty($Name)) { 
    $HasErrorName = " has-error"; 
    $FormError .= "<li>".$set_lang['MAIL_BAD_NAME']."</li>";
  }
  if (filter_var($Email, FILTER_VALIDATE_EMAIL) === false) {
    $HasErrorEmail = " has-error"; 
    $FormError .= "<li>".$set_lang['MAIL_BAD_ADR']."</li>";
  }
  if (empty($Body)) { 
    $HasErrorBody = " has-error"; 
    $FormError .= "<li>".$set_lang['MAIL_BAD_BODY']."</li>";
  }
  if (empty($Captcha) || $Captcha != $_SESSION['digit']) { 
		$HasErrorCaptcha = " has-error"; 
		$FormError .= "<li>".$set_lang['CAPTCHA_ERROR']."</li>";
  }
  
  if (empty($FormError)) {
    $content = nl2br($Body);
	$content = trim($content);
	$message = '<html><body>'.$content.'</body></html>';
	$headers = "From: " . strip_tags($Email) . "\r\n";
	$headers .= "Reply-To: ". strip_tags($Email) . "\r\n";
	$headers .= 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
    if (@mail($e_mail, $Subject, $message, $headers)) {
      $Success = true;
      $Body = '';
	  $message = '';
    } else {
      $MailError = true;
    }
  }
}
function get_map($place) {
	global $set_lang;
	if(!isset($_SESSION['map-zoom']) && return_theme_setting('map-zoom')!='') $_SESSION['map-zoom'] = return_theme_setting('map-zoom');
	if(isset($_GET['zoom_map'])) {
		if($_GET['zoom_map'] == 'reset') $_SESSION['map-zoom'] = return_theme_setting('map-zoom');
		elseif($_GET['zoom_map'] != '1') {
			$_SESSION['map-zoom'] = $_GET['zoom_map'];
		}
		$_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], 0, strpos($_SERVER['REQUEST_URI'], '?'));
	}
	if(return_theme_setting('map-fa') ==  1) {
		$minus_sign = '<i class="icon fa-minus"></i>';
		$plus_sign = '<i class="icon fa-plus"></i>';
		$reset_sign = '<i class="icon fa-undo"></i>';
	} else {
		$minus_sign = '-';
		$plus_sign = '+';
		$reset_sign = 'x';
	}
	$is_class = ($place == 'top' || $place == 'bottom') ? 'gmap-full-breadth on-'.$place.'' : 'gmap-on-side';
	$map_address = return_theme_setting('map-address') ? return_theme_setting('map-address') : 'Williamsburg,Brooklyn,NY';
	$map_lat = return_theme_setting('map-lat') ? return_theme_setting('map-lat') : '11211';
	$map_lot = return_theme_setting('map-lot') ? return_theme_setting('map-lot') : '11222';
	$marker_name = return_theme_setting('map-marker') ? return_theme_setting('map-marker') : 'A';
	$marker_size = return_theme_setting('map-markersize') ? return_theme_setting('map-markersize') : 'mid';
	$marker_color = return_theme_setting('map-color') ? return_theme_setting('map-color') : 'red';
	$map_size = str_replace(' ', '', return_theme_setting('map-size') ? return_theme_setting('map-size') : '320x240');
	$map_type = str_replace(' ', '', return_theme_setting('map-type') ? return_theme_setting('map-type') : 'roadmap');
	$map_key = return_theme_setting('map-key');
	$map_error = return_theme_setting('map-key') ? $set_lang['FX_MAPS_ERROR2'] : $set_lang['FX_MAPS_ERROR1'];
	?>
		<!-- Google Maps -->
			<section class="google-map-container">
				<article>
					<div id="map" class="<?php echo $is_class; ?>">
						<div id="mapbuttons" style="text-align: right;top: 32px;position: relative;z-index: 999;right: 6px;">
							<a href="<?php echo $_SERVER['REQUEST_URI']; ?>?zoom_map=<?php echo $_SESSION['map-zoom']-1; ?>#mapbuttons" class="css-button xsmall" style="font-size: 100%;padding: 0 8px;font-weight: bold;"><?php echo $minus_sign; ?></a>
							<a href="<?php echo $_SERVER['REQUEST_URI']; ?>?zoom_map=reset#mapbuttons" class="css-button xsmall" style="font-size: 90%;padding: 1px 8px;font-weight: bold;"><?php echo $reset_sign; ?></a>
							<a href="<?php echo $_SERVER['REQUEST_URI']; ?>?zoom_map=<?php echo $_SESSION['map-zoom']+1; ?>#mapbuttons" class="css-button xsmall" style="font-size: 100%;padding: 0 8px;font-weight: bold;"><?php echo $plus_sign; ?></a>
						</div>
						<img src="https://maps.googleapis.com/maps/api/staticmap?<?php echo $map_address; ?>&zoom=<?php echo $_SESSION['map-zoom']; ?>&size=<?php echo $map_size; ?>&maptype=<?php echo $map_type; ?>&scale=1&markers=size:<?php echo $marker_size; ?>%7Ccolor:<?php echo $marker_color; ?>%7Clabel:<?php echo $marker_name; ?>%7C<?php echo $map_lat; ?>,<?php echo $map_lot; ?>&key=<?php echo $map_key; ?>" border="0">
						<p style="position: absolute;text-align: center;top: 50%;width: 100%;z-index: -1;"><?php echo $map_error; ?></p>
					</div>
				</article>
			</section>
<?php 
}
?>

<div class="container center">
	<div id="<?php get_page_slug(); ?>" class="grid">
	<?php	if(function_exists('return_theme_setting') && return_theme_setting('gmaps')==1 && return_theme_setting('map-place') == 'top') { ?>
		<div class="width-1-1">
		<?php get_map('top'); ?>
		</div>
		<?php } ?>
		<div class="width-medium-1-2 width-small-1-1 width-tiny-1-1">
			<h1 id="pagetitle"><?php get_page_title(); ?></h1>
				<?php get_page_content(); ?>
	<?php	if(function_exists('return_theme_setting') && return_theme_setting('gmaps')==1 && return_theme_setting('map-place') == 'side') { ?>
			<div class="map-side-outer">
			<?php get_map('side'); ?>
			</div>
	<?php } ?>
		</div>
		<div class="width-medium-1-2 width-small-1-1 width-tiny-1-1">
		 <?php if (!empty($FormError)) { ?>
			<div class="css-alert alert-danger" id="alert-1"><a class="css-close-button" href="#alert-1">&nbsp;</a>
				<p class="css-alert-content"><?php echo $set_lang['MAIL_ERR_SEND']; ?>
					<ul>
						<?php echo $FormError; ?>
					</ul>
				</p>
			</div>
		<?php } else if ($MailError) { ?>
			<div class="css-alert alert-danger" id="alert-1"><a class="css-close-button" href="#alert-1">&nbsp;</a>
				<p class="css-alert-content"><?php echo $set_lang['MAIL_ERR_MAIL']; ?></p>
			</div>
		<?php } else if ($Success) { ?>
			<div class="css-alert alert-danger" id="alert-1"><a class="css-close-button" href="#alert-1">&nbsp;</a>
				<p class="css-alert-content"><?php echo $set_lang['MAIL_SEND_SEC']; ?></p>
			</div>
		<?php }
			if (!filter_var($e_mail, FILTER_VALIDATE_EMAIL) === false) { ?>
			<div class="panel panel-box widget_text">
				<form method="post" class="form-horizontal contact-form">
					<fieldset style="border: none;">
						<legend><?php echo $set_lang['MAIL_LEGEND']; ?></legend>
						<div class="form-group<?php echo $HasErrorName; ?>">
							<label class="control-label" for="txtName">Name</label>
							<div class="input-field">
								<input type="text" id="txtName" name="txtName" class="form-control input-extended" value="<?php echo htmlspecialchars($Name, ENT_QUOTES, "UTF-8"); ?>" placeholder="<?php echo $set_lang['MAIL_NAME']; ?>" />
							</div>
						</div>
						<div class="form-group<?php echo $HasErrorEmail; ?>">
							<label class="control-label" for="txtEmail">E-mail</label>
							<div class="input-field">
								<input type="text" id="txtEmail" name="txtEmail" class="form-control input-extended" value="<?php echo htmlentities($Email); ?>" placeholder="<?php echo $set_lang['MAIL_EMAIL']; ?>" />
							</div>
						</div>
						<div class="form-group<?php echo $HasErrorSubject; ?>">
							<label class="control-label" for="txtSubject">Subject</label>
							<div class="input-field">
								<input type="text" id="txtSubject" name="txtSubject" class="form-control input-extended" value="<?php echo htmlspecialchars($Subject, ENT_QUOTES, "UTF-8"); ?>" placeholder="<?php echo $set_lang['MAIL_SUBJ']; ?>" />
							</div>
						</div>
						<div class="form-group" style="display: none;">
							<label class="control-label" for="txtUrl">Url</label>
							<div class="input-field">
								<input type="text" id="txtUrl" name="txtUrl" class="form-control input-extended" value="<?php echo htmlentities($Url); ?>" placeholder="<?php echo $set_lang['MAIL_SUBJ']; ?>" />
								<span class="help-block">NOTE: Leave this box BLANK!</span>
							</div>
						</div>
						<div class="form-group<?php echo $HasErrorBody; ?>">
							<label class="control-label" for="txtBody">Body</label>
							<div class="input-field">
								<textarea id="txtBody" name="txtBody" class="form-control input-extended" rows="10" placeholder="<?php echo $set_lang['MAIL_BODY']; ?>"><?php echo htmlspecialchars($Body, ENT_QUOTES, "UTF-8"); ?></textarea>
							</div>
						</div>
						<fieldset class="captcha-form <?php echo $HasErrorCaptcha; ?>" style="border: 2px solid;">
							<legend class="captcha-legend control-label">Security Check</legend>
							<div class="<?php echo $HasErrorCaptcha; ?>" style="padding: 6px;">
								<div><img id="captcha" src="<?php get_theme_url(); ?>/antispam/captcha.php" width="160" height="45" border="1" alt="CAPTCHA">
								<small><a href="<?php echo $_SERVER["REQUEST_URI"]; ?>#captcha"><?php echo $set_lang['CAPTCHA_RELOAD']; ?></a></small></div>
								<p><label class="control-label">CAPTCHA<strong>*</strong></label><input id="captcha_code" type="text" name="captcha" size="6" maxlength="5" required=""> <small><?php echo $set_lang['CAPTCHA_TEXT']; ?></small></p>
							</div>
						</fieldset>
						<div class="form-group">
							<div class="width-1-1 align-center" style="margin-top: 20px;">
								<button type="submit" id="cmdSendMessage" name="cmdSendMessage" class="css-button primary"><?php echo $set_lang['MAIL_SEND']; ?></button>
							</div>
						</div>
					</fieldset>
				</form>
			</div>
			<?php } else { ?>
			<div class="alert alert-danger">
				<?php echo $set_lang['MAIL_ERR_ADM']; ?>
			</div> 
			<?php } ?>
               <!-- Contact Form / End -->
		</div>
	</div>
	<?php	if(function_exists('return_theme_setting') && return_theme_setting('gmaps')==1 && return_theme_setting('map-place') == 'bottom') { ?>
		<div class="width-1-1">
		<?php get_map('bottom'); ?>
		</div>
	<?php } ?>
</div>
<!-- Container / End -->
	 
<?php include('footer.inc.php'); ?>
